package gov.va.genisis2.ts.common.exception;

/**
 * Exception class to handle HTTP Status code when no data returned by database
 * 
 * @author Prasad Thummalapalli
 *
 */
public class TSNoDataFoundException extends RuntimeException {

	private static final long serialVersionUID = -1984790310730457516L;

	private final String message;
	private final Throwable throwable;
	
	/**
	 * @param message
	 *            The error message
	 */
	public TSNoDataFoundException(String message) {
		super(message);
		this.message = message;
		this.throwable = null;
	}

	/**
	 * @param message
	 *            The error message
	 * @param throwable
	 *            The throwable exception
	 */
	public TSNoDataFoundException(String message, Throwable throwable) {
		super(message, throwable);
		this.message = message;
		this.throwable = throwable;
	}

	/**
	 * @return the message
	 */
	@Override
	public String getMessage() {
		return message;
	}

	/**
	 * @return the throwable
	 */
	public Throwable getThrowable() {
		return throwable;
	}
}
